//******************************************
// file			: main.c
// version		: V1.0
// brief		: main program
// note			: 
//****************************************** 
/*							Pin Assignment
*********************************************************************
.........................-----------------............................
01.VSS.................01|O              |16.VDD
02.P00/XIN.............02|               |15.P40/AIN0/KWI0
03.P01/XOUT............03|     QFN-16    |14.P41/AIN1/KWI1
04.P10/RESETB..........04|               |13.P42/AIN2/KWI2
05.P71/TC01/PWM01B.....05|               |12.P43/AIN3/KWI3/VREF
06.P90/TX/RX...........06|     LQFP-16   |11.P74/DVOB/AIN8/SI/KWI13      
07.P91/RX/TX...........07|               |10.P76/INT3/SCLK/KWI15
08.P72/TCA0/PPGA0B.....08|	             |9.P70/TC00/PWM00B               
.........................-----------------............................
*********************************************************************/
//******************************************
//Stack Pointer	=	0x23f (If use mq6821_x_startup.asm)
//Ram range = 0x40~0x23f
//******************************************
#ifndef	IO_MEM
#define	IO_MEM
#endif  
#include "MQ6821.h"
#include "MQ6812_REG_BIT.h"
#include "iApp.h"
#include "OPmode.h"


//-- header guards --//


//-- function definition --//




void main()
{
//----------------------------------------------------------------------//
//****** IO, CGCR and P10/P40/P41 initialization during debugging ****************//
//----------------------------------------------------------------------//
	SYSTEM_INIT();		// IO, CGCR and P10/P40/P41 initialization during debugging
//----------------------------------------------------------------------//
	WDCDR.byte = 0x4e;				// clear wdt

//--------------------------------------------------------------------------------------------------//
//	Please set the external crystal (HXTAL/LXTAL) from <OPmode.h> and refer to the following instructions:
//.....................................................................................
//#undef	XTAL_High		// define an external high-frequency crystal: #define(use crystal) / #undef(don't use crystal) :
//#undef	XTAL_Low		// define an external low-frequency crystal: #define(use crystal) / #undef(don't use crystal) :
//.....................................................................................
//	please change the above program in the <OPmode.h> file
//	please pay attention to the external crystal switching in this document
//--------------------------------------------------------------------------------------------------//

//.....................................
//	change the frequency of the internal high-frequency clock (fosc) (FOSCCKS) in SLOW1 mode, default is 16MHz
//	note: The action of changing HIRC cannot be executed during simulation
//.....................................
//	1. switch to SLOW1 mode 
	OpMode_Change_to(iSlow1);		// select the operating mode to be operated to one of (iNor1/iNor2/iSlow2/iSlow1)

//	2. change the frequency of the internal high-frequency clock
	HIRC_ChangeTo_8MHz();			// change the frequency of the internal high-frequency clock (fosc) (FOSCCKS) in SLOW1 mode, default is 16MHz

//	3. switch to NORMAL1 mode  
	OpMode_Change_to(iNor1);		// select the operating mode to be operated to one of (iNor1/iNor2/iSlow2/iSlow1)

	WDCDR.byte = 0x4e;				// clear wdt
//* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	while(1)
	{
		WDCDR.byte = 0x4e;			// clear wdt
		__asm("CPL (_P7DR).6");
		__asm("CPL (_P7DR).6");
		__asm("CPL (_P7DR).6");
		__asm("CPL (_P7DR).6");
	}
//* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

}


